/*
 * File: Shape.java
 * ==============================================================
 * A class representing a shape defined by some polygon.  The
 * points are stored in the order in which they should be connected.
 */

import java.util.*;
import acm.graphics.*;

public class Shape {
	/* The actual point list. */
	private ArrayList<GPoint> points;
	
	/**
	 * Constructs a shape from a list of points.
	 * 
	 * @param points The list of points in the shape.
	 */
	public Shape(ArrayList<GPoint> points) {
		this.points = points;
	}
	
	/**
	 * Returns how many points are in the shape.
	 * 
	 * @return How many points are in the shape.
	 */
	public int numPoints() {
		return points.size();
	}
	
	/**
	 * Returns an iterator that traverses the points in order.
	 * 
	 * @return An iterator that traverses the points in order.
	 */
	public Iterator<GPoint> iterator() {
		return points.iterator();
	}
}
